/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.config;

import com.teamresourceful.resourcefulconfig.common.annotations.Category;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@Category(id="charge", translation="text.respawnobelisks.config.charge_config")
public final class ChargeConfig {
    private static Map<Item, Double> chargeItems = null;
    @ConfigEntry(id="obeliskChargeItems", type=EntryType.STRING, translation="text.respawnobelisks.config.charge_items")
    @Comment(value="The items used for charging an obelisk.\nSyntax: [\"<ITEM_ID>|<CHARGE_AMOUNT>\", ...]\nEx:     [\"minecraft:stick|35\"]")
    public static String[] obeliskChargeItems = new String[]{"minecraft:ender_eye|25", "minecraft:ender_pearl|10"};
    @ConfigEntry(id="obeliskChargeSound", type=EntryType.STRING, translation="text.respawnobelisks.config.obelisk_charge_sound")
    @Comment(value="Sound to play when charging an obelisk.")
    public static String obeliskChargeSound = "minecraft:block.respawn_anchor.charge";
    @ConfigEntry(id="obeliskDepleteSound", type=EntryType.STRING, translation="text.respawnobelisks.config.obelisk_deplete_sound")
    @Comment(value="Sound to play when de-charging(negative charge value) or respawning at an obelisk.")
    public static String obeliskDepleteSound = "minecraft:block.respawn_anchor.deplete";
    @ConfigEntry(id="obeliskSetSpawnSound", type=EntryType.STRING, translation="text.respawnobelisks.config.obelisk_set_spawn_sound")
    @Comment(value="Sound to play when setting your spawn at an obelisk.")
    public static String obeliskSetSpawnSound = "minecraft:block.respawn_anchor.set_spawn";
    @ConfigEntry(id="obeliskDepleteAmount", type=EntryType.INTEGER, translation="text.respawnobelisks.config.obelisk_deplete_amount")
    @Comment(value="How much charge (%) should be consumed when respawning at an obelisk.")
    public static int obeliskDepleteAmount = 20;
    @ConfigEntry(id="infiniteChargeBlock", type=EntryType.STRING, translation="text.respawnobelisks.config.infinite_charge_block")
    @Comment(value="Block placed under an obelisk to allow for infinite charge.")
    public static String infiniteChargeBlock = "minecraft:beacon";
    @ConfigEntry(id="allowEmptySpawnSetting", type=EntryType.BOOLEAN, translation="text.respawnobelisks.config.empty_spawn_setting")
    @Comment(value="Whether players can set their spawn at obelisks without charge.")
    public static boolean allowEmptySpawnSetting = false;

    public static Map<Item, Double> getChargeItems() {
        if (chargeItems != null) {
            return chargeItems;
        }
        chargeItems = new HashMap<Item, Double>();
        for (String str : obeliskChargeItems) {
            String[] sections = str.split("\\|");
            chargeItems.put((Item)Registry.f_122827_.m_7745_(new ResourceLocation(sections[0])), Double.parseDouble(sections[1]));
        }
        return chargeItems;
    }
}

